/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.jellysquid.mods.sodium.client.util.math.ChunkSectionPos;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ClonedChunkSection {
    private static final ExtendedBlockStorage EMPTY_SECTION = new ExtendedBlockStorage(0, false);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Short2ObjectMap<TileEntity> blockEntities;
    private final World world;
    private ChunkSectionPos pos;
    private ExtendedBlockStorage data;
    private Biome[] biomeData;
    private byte[][] lightData;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    ClonedChunkSection(ClonedChunkSectionCache backingCache, World world) {
        this.backingCache = backingCache;
        this.world = world;
        this.blockEntities = new Short2ObjectOpenHashMap();
    }

    public void init(ChunkSectionPos pos) {
        Chunk chunk = this.world.func_72964_e(pos.func_177958_n(), pos.func_177952_p());
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.toChunkPos());
        }
        ExtendedBlockStorage section = ClonedChunkSection.getChunkSection(chunk, pos);
        if (section == Chunk.field_186036_a) {
            section = EMPTY_SECTION;
        }
        this.pos = pos;
        this.data = section;
        this.biomeData = new Biome[chunk.func_76605_m().length];
        StructureBoundingBox box = new StructureBoundingBox(pos.getMinX(), pos.getMinY(), pos.getMinZ(), pos.getMaxX(), pos.getMaxY(), pos.getMaxZ());
        this.blockEntities.clear();
        for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
            BlockPos entityPos = (BlockPos)entry.getKey();
            if (!box.func_175898_b((Vec3i)entityPos)) continue;
            this.blockEntities.put(ChunkSectionPos.packLocal(entityPos), entry.getValue());
        }
        BlockPos.MutableBlockPos biomePos = new BlockPos.MutableBlockPos();
        for (int z = pos.getMinZ(); z <= pos.getMaxZ(); ++z) {
            for (int x = pos.getMinX(); x <= pos.getMaxX(); ++x) {
                biomePos.func_181079_c(x, 100, z);
                this.biomeData[(z & 0xF) << 4 | x & 0xF] = this.world.func_180494_b((BlockPos)biomePos);
            }
        }
    }

    public IBlockState getBlockState(int x, int y, int z) {
        return this.data.func_177485_a(x, y, z);
    }

    public Biome getBiomeForNoiseGen(int x, int z) {
        return this.biomeData[x | z << 4];
    }

    public Biome[] getBiomeData() {
        return this.biomeData;
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        return (TileEntity)this.blockEntities.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public ChunkSectionPos getPosition() {
        return this.pos;
    }

    public int getLightLevel(int x, int y, int z, EnumSkyBlock type) {
        NibbleArray lightArray = type == EnumSkyBlock.BLOCK ? this.data.func_76661_k() : this.data.func_76671_l();
        return lightArray != null ? lightArray.func_76582_a(x, y, z) : type.field_77198_c;
    }

    private static ExtendedBlockStorage getChunkSection(Chunk chunk, ChunkSectionPos pos) {
        ExtendedBlockStorage section = null;
        if (!ClonedChunkSection.isOutsideBuildHeight(ChunkSectionPos.getBlockCoord(pos.func_177956_o()))) {
            section = chunk.func_76587_i()[pos.func_177956_o()];
        }
        return section;
    }

    private static boolean isOutsideBuildHeight(int y) {
        return y < 0 || y >= 256;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    private static short packLocal(int x, int y, int z) {
        return (short)(x << 8 | z << 4 | y);
    }
}

